% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncoMix_two_component_mixture_models.R
\name{scatterMixPlot}
\alias{scatterMixPlot}
\title{Generate a scatter plot with the output from mixModelParams}
\usage{
scatterMixPlot(mmParams, selIndThresh = 1, geneLabels = NULL)
}
\arguments{
\item{mmParams}{The output from the mixModelParams function. Will utilize
the deltaMu2 and deltaMu1 rows.}

\item{selIndThresh}{This is the selectivity index threshold to use. All
genes with SI values above this threshold will be highlighted in purple.
Specify either selIndThresh or geneLabels (not both simultaneously).}

\item{geneLabels}{A character vector of gene names used to label the
genes with that name on the scatter plot. Specify either selIndThresh
or geneLabels (not both simultaneously).}
}
\value{
Returns a ggplot scatter object that can be plotted
}
\description{
This function allows you to generate the parameters for two 2-component
mixture models with equal variances
}
\examples{
exprNml <- as.data.frame(matrix(data=rgamma(n=150, shape=2, rate=2),
nrow=10, ncol=15))
colnames(exprNml) <- paste0("patientN", seq_len(ncol(exprNml)))
rownames(exprNml) <- paste0("gene", seq_len(nrow(exprNml)))

exprTum <- as.data.frame(matrix(data=rgamma(n=150, shape=4, rate=3),
nrow=10, ncol=15))
colnames(exprTum) <- paste0("patientT", seq_len(ncol(exprTum)))
rownames(exprTum) <- paste0("gene", seq_len(nrow(exprTum)))

mmParams <- mixModelParams(exprNml, exprTum)
scatterMixPlot(mmParams)
}
\seealso{
\code{\link{mixModelParams}}
}
\keyword{oncoMix,}
\keyword{two-component}
\keyword{visualization,}
