% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncoscanR-package.R
\docType{package}
\name{oncoscanR-package}
\alias{oncoscanR}
\alias{oncoscanR-package}
\title{oncoscanR: an R package to perform secondary analysis of Copy Number 
Variation data.}
\description{
Allows computation of different homologous recombination deficiency (HRD) 
scores to identify PARP inhibitors responders. The package also allows for 
computation of the tandem duplication plus score (TDplus; hallmark of 
CDK12-mutated tumors) and the identification of arm-level alterations (e.g. 
gain of chromosome arm 1p).
}
\details{
The package is tailored for the ThermoFisher Oncoscan assay analyzed with 
their Chromosome Alteration Suite (ChAS) but can be adapted to any input.

To learn more about \code{oncoscanR}, see the vignette using 
\code{browseVignettes(package = "oncoscanR")}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/yannchristinat/oncoscanR}
  \item Report bugs at \url{https://github.com/yannchristinat/oncoscanR/issues}
}

}
\author{
\strong{Maintainer}: Yann Christinat \email{yann.christinat@hcuge.ch}

Authors:
\itemize{
  \item Geneva University Hospitals [copyright holder]
}

}
\keyword{internal}
