% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{prune_by_size}
\alias{prune_by_size}
\title{Remove segments smaller than the kit resolution.}
\usage{
prune_by_size(segments, threshold = 300)
}
\arguments{
\item{segments}{A \code{GRanges} object containing the segments, their copy
number and copy number types.}

\item{threshold}{Number indicating the minimum segment size to be kept (in
kilobases).
Defaults to the Oncoscan assay resolution outside of cancer genes: 300Kb.}
}
\value{
A \code{GRanges} object containing the cleaned segments, their copy
number and copy number types.
}
\description{
Remove segments smaller than the kit resolution.
}
\examples{
segs.300k <- prune_by_size(segs.chas_example)
segs.50k <- prune_by_size(segs.chas_example, 50)
}
