% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/termProc.R
\name{cellTypeToGO}
\alias{cellTypeToGO}
\alias{cellTypeToGenes}
\title{utilities for approximate matching of cell type terms to GO categories and annotations}
\usage{
cellTypeToGO(celltypeString, gotab, ...)

cellTypeToGenes(
  celltypeString,
  gotab,
  orgDb,
  cols = c("ENSEMBL", "SYMBOL"),
  ...
)
}
\arguments{
\item{celltypeString}{character atom to be used to search GO terms using}

\item{gotab}{a data.frame with columns GO (goids) and TERM (term strings)
\code{\link[base]{agrep}}}

\item{\dots}{additional arguments to \code{\link[base]{agrep}}}

\item{orgDb}{instances of orgDb}

\item{cols}{columns to be retrieved in select operation}
}
\value{
data.frame

data.frame
}
\description{
utilities for approximate matching of cell type terms to GO categories and annotations
}
\note{
Very primitive, uses agrep to try to find relevant terms.
}
\examples{
library(org.Hs.eg.db)
data(allGOterms)
head(cellTypeToGO("serotonergic neuron", allGOterms))
head(cellTypeToGenes("serotonergic neuron", allGOterms, org.Hs.eg.db))
}
