% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLextend.R
\name{cyclicSigset}
\alias{cyclicSigset}
\title{as in Bakken et al. (2017 PMID 29322913) create gene signatures for k
cell types, each of which fails to express all but one gene in a set of k genes}
\usage{
cyclicSigset(
  idvec,
  conds = c("hasExp", "lacksExp"),
  tags = paste0("CL:X", 1:length(idvec))
)
}
\arguments{
\item{idvec}{character vector of identifiers, must have names() set to identify cells bearing genes}

\item{conds}{character(2) tokens used to indicate condition to which signature element contributes}

\item{tags}{character vector of cell-type identifiers; for Cell Ontology use CL: as prefix,
one element for each element of idvec}
}
\value{
a long data.frame
}
\description{
as in Bakken et al. (2017 PMID 29322913) create gene signatures for k
cell types, each of which fails to express all but one gene in a set of k genes
}
\examples{
sigels = c("CL:X01"="GRIK3", "CL:X02"="NTNG1", "CL:X03"="BAGE2", 
        "CL:X04"="MC4R", "CL:X05"="PAX6", "CL:X06"="TSPAN12", "CL:X07"="hSHISA8", 
     "CL:X08"="SNCG", "CL:X09"="ARHGEF28", "CL:X10"="EGF")
sigdf = cyclicSigset(sigels)
head(sigdf)
}
