#' Multiplex PCR Primer Design and Analysis.
#'
#' With openPrimeR you can evaluate existing
#' primers or design novel primers for multiplex
#' polymerase chain reaction that are optimized with respect
#' to the coverage of template sequences and the physicochemical
#' properties of the primers.
#'
#' For designing primers, you just need the function \code{\link{design_primers}}
#' from \pkg{openPrimeR}. As a minimal input, this function requires:
#' \describe{
#' \item{A set of template sequences}{You an load a \code{\link{Templates}} object with \code{\link{read_templates}}.}
#' \item{Settings for primer design}{You can load a \code{\link{DesignSettings}} object from a (supplied) XML file with \code{\link{read_settings}}.
#' The settings can be easily customized using the setters \code{\link{constraints}}, \code{\link{constraintLimits}}, \code{\link{cvg_constraints}}, \code{\link{conOptions}}, and \code{\link{PCR}}.}
#' }
#' For evaluating existing primers you can load a FASTA or CSV file 
#' containing the primers and templates of of interest using
#' \code{\link{read_primers}} and \code{\link{read_templates}}, respectively.
#' After evaluating the properties of the primers
#' using \code{\link{check_constraints}}, you can interpret the results 
#' with several functions. For example, you can analyze the coverage of 
#' the template sequences using \code{\link{get_cvg_stats}}, determine 
#' the deviation from the target constraints using \code{\link{plot_constraint_deviation}}, or create a comprehensive report on the analyzed
#' primers using \code{\link{create_report}}.
#' In order to compare several primer sets with each other,
#' you can create a table of the 
#' properties of the primer sets using \code{get_comparison_table}
#' or create a full report, again using \code{\link{create_report}}.
#'
#' @section Package options:
#' openPrimeR uses the following options:
#' \describe{
#'   \item{\code{openPrimeR.constraint_order}}{The identifiers of constraints 
#' in the order they are applied during the filtering procedure. 
#' This order is maintained when loading a \code{DesignSettings} object.}
#'   \item{\code{openPrimeR.relax_order}}{The identifiers of constraints in the order in which they shall be relaxed during the relaxation procedure when designing primers.}
#'   \item{\code{openPrimeR.plot_abbrev}}{The maximal number of allowed characters for tick labels in plots.}
#'   \item{\code{openPrimeR.plot_colors}}{A named vector providing the identifiers of RColorBrewer palettes. Each vector entry provides the plotting colors for a specific type of stratification (i.e. by run, constraint, or primer). The palettes should provide at least eight colors.}
#' }
"_PACKAGE" 
