% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R, R/primers.R, R/IO.R, R/Output.R,
%   R/settings.R
\name{Output}
\alias{Output}
\alias{write_templates}
\alias{write_primers}
\alias{create_coverage_xls}
\alias{create_report}
\alias{write_settings}
\title{Output Functionalities.}
\usage{
write_templates(template.df, fname, ftype = c("FASTA", "CSV"))

write_primers(primer.df, fname, ftype = c("FASTA", "CSV"))

create_coverage_xls(primer.df, template.df, fname, settings)

create_report(
  primers,
  templates,
  fname,
  settings,
  sample.name = NULL,
  used.settings = NULL,
  ...
)

write_settings(settings, fname)
}
\arguments{
\item{template.df}{An object of class \code{Templates}.}

\item{fname}{The path to the output file.}

\item{ftype}{A character vector giving the type of the file.
This can either be "FASTA" or "CSV" (default: "FASTA").}

\item{primer.df}{An object of class \code{Primers}.}

\item{settings}{A \code{DesignSettings} object to be stored to disk.}

\item{primers}{To create a report for a single primer set, please provide
an evaluated \code{Primers} object.
For creating a report comparing multiple primer sets, please provide
a list of \code{Primers} objects.}

\item{templates}{If \code{primers} is a \code{Primers} object, \code{templates} should be a \code{Templates} object.
If \code{primers} is a list of \code{Primers} objects, \code{templates}
should be a list of \code{Templates} objects of the same length as \code{primers}.}

\item{sample.name}{An identifier for your analysis. By default ( 
\code{NULL}), the sample identifier is selected from the
\code{Run} column of the input templates.}

\item{used.settings}{A named list (with fields \code{fw} and \code{rev}) containing the relaxed settings
for designing forward/reverse primers. By default (\code{NULL}), 
the relaxed settings are not shown in the report.}

\item{...}{\code{required.cvg} (optional, default: 1), the desired coverage ratio if \code{primers} is a single primer set.}
}
\value{
\code{write_templates} stores templates to \code{fname}.

\code{write_primers} stores primers to disk.

\code{create_coverage_xls} stores information on the
primer coverage in a spreadsheet.

\code{create_report} Creates a PDF file summarizing the results
from analyzing one or multiple sets of primers.

\code{write_settings} returns the status from closing the connection to the output file.
}
\description{
\describe{
\item{\code{write_primers}}{Writes a set of primers to disk, either as a FASTA or CSV file.}
\item{\code{write_settings}}{ Stores primer analysis settings to a file in XML format.}
\item{\code{write_templates}}{Stores a set of templates as a FASTA or CSV file.}
\item{\code{create_report}}{Creates a PDF report for analyzed primer sets.}
\item{\code{create_coverage_xls}}{Creation of an XLS spreadsheet 
providing an overview of the covered
template sequences for each primer. Each cell in the spreadsheet
indicates a coverage event between a primer and template using
color codes. Identified coverage events are indicated by green, while
primer-template pairs without coverage are indicated by red.
In case that a primer binding condition (see \code{\link{CoverageConstraints}})
was active when computing the coverage, the numeric value of the
coverage condition is annotated for each cell.}
}
}
\note{
Creating the report requires the external programs Pandoc (http://pandoc.org)
and LaTeX (http://latex-project.org).
}
\examples{

data(Ippolito)
# Store templates as FASTA
fname.fasta <- tempfile("my_templates", fileext = ".fasta")
write_templates(template.df, fname.fasta)
# Store templates as CSV
fname.csv <- tempfile("my_templates", fileext = ".csv")
write_templates(template.df, fname.csv, "CSV")

data(Ippolito)
# Store primers as FASTA
fname.fasta <- tempfile("my_primers", fileext = ".fasta")
write_primers(primer.df, fname.fasta)
# Store primers as CSV
fname.csv <- tempfile("my_primers", fileext = ".csv")
write_primers(primer.df, fname.csv, "CSV")

data(Ippolito)
filename <- tempfile("cvg_overview", fileext = ".xls")
# Store coverage of a single primer in an XLS file:
my.primers <- primer.df[3,]
cvd <- unique(unlist(strsplit(my.primers$Covered_Seqs, split = ",")))
m <- match(cvd, template.df$Identifier)
my.templates <- template.df[m,]
create_coverage_xls(my.primers, my.templates, filename, settings)

setting.xml <- system.file("extdata", "settings", 
                 "C_Taq_PCR_high_stringency.xml", package = "openPrimeR")
settings <- read_settings(setting.xml)
# Creation of a report for a single primer set
data(Ippolito)
out.file.single <- tempfile("evaluation_report", fileext = ".pdf")
create_report(primer.df, template.df, out.file.single, settings)
# Creation of a report for multiple primer sets
data(Comparison)
set.sizes <- sapply(primer.data, nrow)
sel.sets <- order(set.sizes)[1:2]
out.file.comp <- tempfile("comparison_report", fileext = ".pdf")
create_report(primer.data[sel.sets], template.data[sel.sets], out.file.comp, settings)

# Store settings to disk
xml <- system.file("extdata", "settings", 
       "C_Taq_PCR_high_stringency.xml", package = "openPrimeR")
settings <- read_settings(xml)
out.file <- tempfile("my_settings", fileext = ".xml")
write_settings(settings, out.file)
}
