% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints_eval.R
\name{check_cvg_constraints}
\alias{check_cvg_constraints}
\title{Evaluation of Coverage Constraints.}
\usage{
check_cvg_constraints(
  primer.df,
  template.df,
  settings,
  active.constraints = names(cvg_constraints(settings)),
  to.compute.constraints = active.constraints,
  for.shiny = FALSE,
  updateProgress = NULL
)
}
\arguments{
\item{primer.df}{A \code{Primers} object containing the primers
to be checked.}

\item{template.df}{A \code{Templates} object containing the 
template sequences corresponding to the primers.}

\item{settings}{A \code{DesignSettings} object containing the 
coverage constraints to be checked and their settings.}

\item{active.constraints}{Identifiers of constraints that are to be checked.}

\item{to.compute.constraints}{Constraints that are to be computed.}

\item{for.shiny}{Whether to format output for HTML.}

\item{updateProgress}{Progress callback function for shiny.}
}
\value{
A \code{Primers} object with with columns for each constraint in \code{active.constraints}.
}
\description{
Computes the biochemical properties specified in the
\code{settings} object and determines whether the primers
fulfill the required constraints.
}
\note{
Please note that some constraints can only be computed if additional software is installed,
please see \code{\link{DesignSettings}} for an overview.
}
\keyword{internal}
