% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_greedy.R
\name{select.primers.by.cvg}
\alias{select.primers.by.cvg}
\title{Greedy Optimization.}
\usage{
select.primers.by.cvg(
  primers,
  settings,
  template.df,
  mode.directionality = c("fw", "rev"),
  required.cvg = 1,
  allowed.mismatches,
  primer_conc,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  template_conc,
  allowed.other.binding.ratio,
  allowed.stop.codons,
  allowed.region.definition = c("within", "any"),
  disallowed.mismatch.pos,
  target.temps = NULL,
  fw.primers = NULL,
  updateProgress = NULL
)
}
\arguments{
\item{primers}{Primer data frame to be optimized.}

\item{settings}{A \code{DesignSettings} object.}

\item{template.df}{Template data frame.}

\item{mode.directionality}{Primer direction.}

\item{required.cvg}{Target coverage ratio.}

\item{allowed.mismatches}{The number of mismatches primers are allowed to have with the templates.}

\item{primer_conc}{Primer concentration.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris ion concentration.}

\item{template_conc}{Template data frame.}

\item{allowed.other.binding.ratio}{Ratio of primers allowed to bind to non-target regions.}

\item{allowed.stop.codons}{Consider mismatch binding events that induce stop codons.}

\item{allowed.region.definition}{Definition of the target binding sites used for evaluating the coverage.
If \code{allowed.region.definition} is \code{within}, primers have to lie within the allowed binding region.
If \code{allowed.region.definition} is \code{any}, primers have to overlap with the allowed binding region.
The default is that primers have to bind within the target binding region.}

\item{disallowed.mismatch.pos}{The number of positions from the primer 3' end where mismatches should not be allowed.
All primers binding templates with mismatches within \code{disallowed.mismatch.pos} from the 3' end are disregarded.}

\item{target.temps}{Target melting temperatures for optimized sets in Celsius.}

\item{fw.primers}{List with already optimized primer data frames corresponding to \code{target.temps}.}

\item{updateProgress}{Shiny progress callback function.}
}
\value{
List with optimization data.
}
\description{
Greedy approach for solving the primer set coverage problem.
}
\keyword{internal}
