% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimalFlowTemplates.R
\name{optimalFlowTemplates}
\alias{optimalFlowTemplates}
\title{optimalFlowTemplates}
\usage{
optimalFlowTemplates(
  database,
  database.names = NULL,
  cov.estimation = "standard",
  alpha.cov = 0.85,
  equal.weights.template = TRUE,
  hclust.method = "complete",
  trimm.template = FALSE,
  templates.number = NA,
  minPts = 2,
  eps = 1,
  consensus.method = "pooling",
  barycenters.number = NA,
  bar.repetitions = 40,
  alpha.bar = 0.05,
  bar.ini.method = "plus-plus",
  consensus.minPts = 3,
  cl.paral = 1
)
}
\arguments{
\item{database}{A list where each entry is a partition (clustering) represented as dataframe, of the same dimensions, where the last variable represents the labels of the partition.}

\item{database.names}{Names of the elements in the database.}

\item{cov.estimation}{How to estimate covariance matrices in each cluster of a partition. 'standard' is for using cov(), while 'robust' is for using robustbase::covMcd.}

\item{alpha.cov}{Only when cov.estimation = 'robust'. Indicates the value of alpha in robustbase::covMcd.}

\item{equal.weights.template}{If True, weights assigned to every cluster in a partion are uniform (1/number of clusters). If False, weights assigned to clusters are the proportions of points in every cluster compared to the total amount of points in the partition.}

\item{hclust.method}{Indicates what kind of hierarchical clustering to  do with the similarity distances matrix of the partitions. Takes values in c('complete', 'single', 'average', 'hdbscan', 'dbscan').}

\item{trimm.template}{Logical value. Indicates if it is allowed to not take into account some of the entries of database. Default is False.}

\item{templates.number}{Only if hclust.method in c('complete', 'single', 'average'). Indicates the number of clusters to use with cutree. If set to NA (default), plots the hierarchical tree and asks the user to introduce an appropriate number of clusters.}

\item{minPts}{Only if hclust.method in c('hdbscan', 'dbscan'). Indicates the value of argument minPts in dbscan::dbscan and dbscan::hdbscan.}

\item{eps}{Only if hclust.method = 'dbscan'. Indicates the value of eps in dbscan::dbscan.}

\item{consensus.method}{Sets the way of doing consensus clustering when clusters are viewed as Multivariate Distributions. Can take values in c('pooling', 'k-barycenter', 'hierarchical'). See details.}

\item{barycenters.number}{Only if consensus.method = 'k-barycenter'. Sets the number, k, of barycenters when using k-barycenters.}

\item{bar.repetitions}{Only if consensus.method = 'k-barycenter'. How many times to repeat the k-barycenters procedure. Equivalent to nstart in kmeans.}

\item{alpha.bar}{Only if consensus.method = 'k-barycenter'. The level of trimming allowed during the k-barycenters procedure.}

\item{bar.ini.method}{Only if consensus.method = 'k-barycenter'. Takes values in c('rnd', 'plus-plus'). See details.}

\item{consensus.minPts}{Only if consensus.method = 'hierarchical'. The value of argument minPts for dbscan::hdbscan.}

\item{cl.paral}{Number of cores to be used in parallel procedures.}
}
\value{
A list containting:
\describe{
 \item{templates}{A list representing the consensus clusterings for every group in the partition of the database. Each element of the list is a template partition. Hence it is a list itself, containig the cell types in the prototype, where each element has components: mean, cov, weight and type.}
 \item{clustering}{Clustering of the input partitions.}
 \item{database.elliptical}{A list containig each cytometry in the database viewed as a mixture distribution. Each element of the list is a cytometry viewed as a mixture. Hence it is a list itself, containig the cell types in the cytometry, where each element has components: mean, cov, weight and type.}
}
}
\description{
Returns a partition of the input clusterings with a respective consensus clustering for every group.
}
\examples{
# # We construct a simple database selecting only some of the Cytometries and some cell types for simplicity and for a better visualisation.
database <- buildDatabase(
  dataset_names = paste0('Cytometry', c(2:5, 7:9, 12:17, 19, 21)),
    population_ids = c('Monocytes', 'CD4+CD8-', 'Mature SIg Kappa', 'TCRgd-'))

# # To select the appropriate number of templates, via hierarchical tree, in an interactive fashion and produce a clustering we can also use:
# templates.optimalFlow <- optimalFlowTemplates(database = database)

templates.optimalFlow <- optimalFlowTemplates(database = database, templates.number = 5,
                                             cl.paral = 1)

}
\references{
E del Barrio, H Inouzhe, JM Loubes, C Matran and A Mayo-Iscar. (2019) optimalFlow: Optimal-transport approach to flow cytometry gating and population matching. arXiv:1907.08006
}
