% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPacksFromGRanges.R
\name{getPacksFromGRanges}
\alias{getPacksFromGRanges}
\title{Retrieve packFinder Results from GRanges Object}
\usage{
getPacksFromGRanges(packGRanges, Genome = NULL, tsdLength = NULL)
}
\arguments{
\item{packGRanges}{\code{link[GenomicRanges:GRanges-class]{GRanges}}
object to be coerced.}

\item{Genome}{(optional) Sequences referred to by \code{packGRanges}.}

\item{tsdLength}{(optional) Length of TSD sequences.}
}
\value{
Dataframe in the format used by \code{\link{packSearch}}. 
If \code{Genome} and \code{tsdLength} are supplied, then 
TSD sequences are retrieved and returned 
as part of the dataframe.
}
\description{
A \code{link[GenomicRanges:GRanges-class]{GRanges}}  
object, potentially 
generated using \code{\link{packSearch}} and 
\code{\link{packsToGRanges}}, can be converted to a 
dataframe. If a GRanges object is supplied without TSD 
information, this can be calculated and appended to the 
final dataframe.
}
\examples{
data(packMatches)

GRangesObject <- packsToGRanges(packMatches)
packMatches <- getPacksFromGRanges(GRangesObject)

}
\seealso{
\code{\link{packsToGRanges}}, 
\code{link[GenomicRanges:GRanges-class]{GRanges}},
\code{\link{packSearch}}
}
\author{
Jack Gisby
}
