% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRCs.R
\name{countBamListInGRanges}
\alias{countBamListInGRanges}
\title{Get read counts for a list of BAM files and given count windows}
\usage{
countBamListInGRanges(bam.files, countWindows, read.width = 150, ...)
}
\arguments{
\item{bam.files}{list with absolute or relative paths to BAM files}

\item{countWindows}{data.frame with contents of a BED file as returned by
getWindows}

\item{read.width}{read.width parameter for countBamInGRanges or FALSE if
actual read width should be extracted from BAM file}

\item{...}{additional parameters}
}
\value{
a GRanges object over the countWindows with read counts for each
sample as elementMetadata
}
\description{
Get read counts for a list of BAM files and given count windows
}
\examples{
bed <- system.file("extdata/Genes_part.bed", package = "panelcn.mops")
countWindows <- getWindows(bed)
\dontrun{
testbam <- "SAMPLE1.bam"
test <- countBamListInGRanges(countWindows = countWindows,
                                bam.files = testbam, read.width = 150)
}
}
