% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_peakPantheRAnnotation.R
\docType{methods}
\name{annotationDiagnosticPlots,peakPantheRAnnotation-method}
\alias{annotationDiagnosticPlots,peakPantheRAnnotation-method}
\alias{annotationDiagnosticPlots}
\title{Generate fit diagnostic plots}
\usage{
\S4method{annotationDiagnosticPlots}{peakPantheRAnnotation}(
    object,
    sampleColour,
    sampling,
    verbose
)
}
\arguments{
\item{object}{(peakPantheRAnnotation) Annotated peakPantheRAnnotation object}

\item{sampleColour}{(str) NULL or vector colour for each sample}

\item{sampling}{(int) Number of points to employ when plotting fittedCurve}

\item{verbose}{(bool) if TRUE message the plot generation progress}
}
\value{
A list (one list per compound) of diagnostic plots:
\code{result[[i]]$EICFit}, \code{result[[i]]$rtPeakwidthVert},
\code{result[[i]]$rtPeakwidthHorzRunOrder},
\code{result[[i]]$mzPeakwidthHorzRunOrder}, \code{result[[i]]$areaRunOrder},
\code{result[[i]]$rtHistogram}, \code{result[[i]]$mzHistogram},
\code{result[[i]]$areaHistogram}, \code{result[[i]]$title}
}
\description{
Generate fit diagnostic plots for each ROI: \code{EICFit} the
raw data and detected feature fit, \code{rtPeakwidthVert} detected peaks
retention time apex and peakwidth (vertical and no run order),
\code{rtPeakwidthHorzRunOrder} detected peaks retention time apex and
peakwidth by run order, \code{mzPeakwidthHorzRunOrder} detected peaks m/z
apex and peakwidth by run order, \code{areaRunOrder} detected peaks area by
run order, \code{rtHistogram} histogram of detected peaks retention time,
\code{mzHistogram} histogram of detected peaks m/z, \code{areaHistogram}
histogram of detected peaks area.
}
\examples{
if(requireNamespace('faahKO')){
## Initialise a peakPantheRAnnotation object with 3 samples and 2 targeted
## compounds

# Paths to spectra files
library(faahKO)
spectraPaths <- c(system.file('cdf/KO/ko15.CDF', package = 'faahKO'),
                    system.file('cdf/KO/ko16.CDF', package = 'faahKO'),
                    system.file('cdf/KO/ko18.CDF', package = 'faahKO'))

# targetFeatTable
targetFeatTable <- data.frame(matrix(vector(), 2, 8, dimnames=list(c(),
                    c('cpdID','cpdName','rtMin','rt','rtMax','mzMin','mz',
                    'mzMax'))), stringsAsFactors=FALSE)
targetFeatTable[1,] <- c('ID-1', 'Cpd 1', 3310., 3344.888, 3390., 522.194778,
                        522.2, 522.205222)
targetFeatTable[2,] <- c('ID-2', 'Cpd 2', 3280., 3385.577, 3440., 496.195038,
                        496.2, 496.204962)
targetFeatTable[,c(3:8)] <- vapply(targetFeatTable[,c(3:8)], as.numeric,
                                    FUN.VALUE=numeric(2))

emptyAnnotation <- peakPantheRAnnotation(spectraPaths=spectraPaths,
                                        targetFeatTable=targetFeatTable)

annotationDiagnosticPlots(emptyAnnotation)
# Warning: the object has not been annotated, return an empty diagnostic plot
# list
# [[1]]
# NULL
# [[2]]
# NULL
}
}
