% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtCorrection_utils.R
\name{peakPantheR_applyRTCorrection}
\alias{peakPantheR_applyRTCorrection}
\title{Correct targeted retention time based on reference compounds}
\usage{
peakPantheR_applyRTCorrection(
    targetFeatTable,
    referenceTable,
    method = "polynomial",
    params = list(polynomialOrder = 3),
    robust = TRUE
)
}
\arguments{
\item{targetFeatTable}{a \code{\link{data.frame}} of compounds to target as
rows and parameters as columns: \code{cpdID} (str), \code{cpdName} (str),
\code{rtMin} (float in seconds), \code{rt} (float in seconds, or \emph{NA}),
\code{rtMax} (float in seconds), \code{mzMin} (float), \code{mz} (float or
\emph{NA}), \code{mzMax} (float).}

\item{referenceTable}{a \code{\link{data.frame}} of reference compound
information as rows and properties as columns: \code{cpdID} (str),
\code{cpdName} (str), \code{rt} (float), \code{rt_dev_sec} (float)}

\item{method}{(str) name of RT correction method to use (currently
\code{polynomial})}

\item{params}{(list) list of parameters to pass to
the each correction method.
Currently allowed inputs are \code{polynomialOrder} for
\code{method='polynomial'}}

\item{robust}{(bool) whether to use the RANSAC algorithm to flag and
ignore outliers during retention time correction}
}
\value{
a targetFeatTable with corrected RT
}
\description{
Correct targeted features retention time using the RT and RT deviation of
previously fitted compounds. The `method` and `params` are used to select and
parametrise the retention time correction method employed. When `robust`
is set to TRUE, the RANSAC algorithm is used
to automatically flag outliers and robustify the correction function fitting.
}
