% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createES.R
\name{createES}
\alias{createES}
\title{Create ExpressionSet.}
\usage{
createES(data, pData, varLabels, fData, fvarLabels, eData)
}
\arguments{
\item{data}{Gene expression matrix.}

\item{pData}{Matrix with phenotypical data.}

\item{varLabels}{Names of phenoData columns.}

\item{fData}{Matrix with feature data.}

\item{fvarLabels}{Names of featureData columns.}

\item{eData}{List with experimentData}
}
\value{
produced ExpressionSet object
}
\description{
\code{createES} function produces an ExpressionSet object from given data,
    and exports it to global scope.
}
\examples{
\dontrun{
data <- matrix(1:15, 5, 3)
pData <- c("A", "B", "C")
varLabels <- "cat"
fData <- c("p", "r", "s", "t", "u")
fvarLabels <- "id"
eData <- list(name="", lab="", contact="", title="", url="", other=list(), pubMedIds="")
createES(data, pData, varLabels, fData, fvarLabels, eData)
}
}
\keyword{internal}
