% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkPlot.R
\name{networkPlot}
\alias{networkPlot}
\title{Gene set network plot}
\usage{
networkPlot(
  gsaRes,
  class,
  direction,
  adjusted = FALSE,
  significance = 0.001,
  geneSets = NULL,
  overlap = 1,
  lay = 1,
  label = "names",
  cexLabel = 0.9,
  ncharLabel = 25,
  cexLegend = 1,
  nodeSize = c(10, 40),
  edgeWidth = c(1, 15),
  edgeColor = NULL,
  scoreColors = NULL,
  main
)
}
\arguments{
\item{gsaRes}{an object of class \code{GSAres}, as returned from
\code{runGSA()} or an object returned from \code{runGSAhyper()}.}

\item{class}{a character string determining the p-values of which
directionality class that should be used as significance information for the
plot. Can be one of \code{"distinct"}, \code{"mixed"}, \code{"non"}. Has to
be \code{"non"} if the result from \code{runGSAhyper()} is used.}

\item{direction}{a character string giving the direction of regulation, can
be either \code{"up"}, \code{"down"} or \code{"both"} (for
\code{class="distinct"} only).}

\item{adjusted}{a logical, if adjusted p-values should be used, or not. Note
that if \code{runGSA} was run with the argument \code{adjMethod="none"}, the
adjusted p-values will be equal to the original p-values.}

\item{significance}{the significance cut-off that determines which gene sets
are included in the plot. Defaults to 0.001.}

\item{geneSets}{a character vector of gene set names, to be included in the
plot. Defaults to \code{NULL}, but if given, the argument
\code{significance} will not be used.}

\item{overlap}{a positive numerical. Determines the smallest number of
sharing genes between two gene-sets that is needed in order to draw a
line/edge between the gene-sets. Defaults to 1.}

\item{lay}{a numerical between 1-5, or a layout function (see
\code{\link{layout}} in the \code{igraph} package). 1-5 sets the layout to
one of the five default layout for the network plot.}

\item{label}{a character string, either \code{"names"} ,\code{"numbers"},
\code{"numbersAndSizes"} or \code{"namesAndSizes"}, determining the labels
used for the nodes. The names are the gene set names, numbers is an
arbritary numbered list of the gene sets used in the plot connected to the
named list returned by the funtion. Sizes are the gene set sizes, e.g. the
number of genes.}

\item{cexLabel}{the text size of the node labels.}

\item{ncharLabel}{the number of characters to include in the node labels.}

\item{cexLegend}{the text size of the legend.}

\item{nodeSize}{a numerical vector of length 2 giving the maximum and
minimum node sizes. The node size represents the size of the gene set, and
all values will be scaled to the given interval.}

\item{edgeWidth}{a numerical vector of length 2 giving the maximum and
minimum edge widths. The edge width represents the number of shared genes
between two gene sets, and all values will be scaled to the given interval.}

\item{edgeColor}{a character vector giving the colors to use for increasing
edge width. Can also be set to a single color. Defaults to a gray-scale.}

\item{scoreColors}{a character vector giving the colors from which the
gradient used for node coloring will be created. In the case of
\code{class="distinct"} and \code{direction="both"} the first half of the
vector will be used for the up-regulated gene sets and the second part will
be used for the down-regulated gene sets.}

\item{main}{an optional character vector setting the title of the plot.}
}
\value{
Returns a list with two components: \code{geneSets} containing the
names and numbers of the gene sets in the plot, and \code{layout},
containing the saved layout of the plot, which can be passed back to the
\code{lay} argument in order to draw a subsequent plot with the same layout.
}
\description{
Draws a network with gene sets as nodes and the thickness of the edges
correlating to the number of shared genes. The gene set significance is
visualized as color intensities. Gives an overview of the influence of
overlap on significant gene sets.
}
\details{
In the case of \code{class="distinct"} and \code{direction="both"}, the
distinct directional p-values (\code{pDistinctDirUp} and
\code{pDistinctDirDn}, see \code{\link{runGSA}}) will be used in
combination. Using the \code{geneSets} and \code{lay} arguments, multiple
comparative plots (i.e. with the same layout) can be drawn, based for
instance on the output gene set list from other network plots with different
directionality classes.
}
\examples{

   # Load example input data to GSA:
   data("gsa_input")
   
   # Load gene set collection:
   gsc <- loadGSC(gsa_input$gsc)
      
   # Run gene set analysis:
   gsares <- runGSA(geneLevelStats=gsa_input$pvals , directions=gsa_input$directions, 
                    gsc=gsc, nPerm=500)
      
   # Network plot:
   networkPlot(gsares,class="non",significance=0.01)
   
   # Use circular layout and save the layout:
   nw <- networkPlot(gsares,class="non",significance=0.01,lay=5)
   
   # Use the saved layout to overlay the distinct-directional p-values for easy comparison.
   # Note that the gene sets are now not selected based on a significance cutoff, but from a list:
   networkPlot(gsares,class="distinct",direction="both",lay=nw$layout,geneSets=nw$geneSets)

}
\seealso{
\pkg{\link{piano}}, \code{\link{runGSA}}, \code{\link{GSAheatmap}}, 
\code{\link{networkPlot2}}, \code{\link{exploreGSAres}},
\code{\link{layout}}
}
\author{
Leif Varemo \email{piano.rpkg@gmail.com} and Intawat Nookaew
\email{piano.rpkg@gmail.com}
}
