% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipelineDefinition.R
\name{PipelineDefinition}
\alias{PipelineDefinition}
\alias{PipelineDefinition-class}
\title{PipelineDefinition}
\usage{
PipelineDefinition(
  functions,
  descriptions = NULL,
  evaluation = NULL,
  aggregation = NULL,
  initiation = identity,
  defaultArguments = list(),
  misc = list(),
  verbose = TRUE
)
}
\arguments{
\item{functions}{A list of functions for each step}

\item{descriptions}{A list of descriptions for each step}

\item{evaluation}{A list of optional evaluation functions for each step}

\item{aggregation}{A list of optional aggregation functions for each step}

\item{initiation}{A function ran when initiating a dataset}

\item{defaultArguments}{A lsit of optional default arguments}

\item{misc}{A list of whatever.}

\item{verbose}{Whether to output additional warnings (default TRUE).}
}
\value{
An object of class `PipelineDefinition`, with the slots functions,
descriptions, evaluation, aggregation, defaultArguments, and misc.
}
\description{
Creates on object of class `PipelineDefinition` containing step functions,
as well as optionally step evaluation and aggregation functions.
}
\examples{
PipelineDefinition(
  list( step1=function(x, meth1){ get(meth1)(x) },
        step2=function(x, meth2){ get(meth2)(x) } )
)
}
\seealso{
\code{\link{PipelineDefinition-methods}}, 
\code{\link{addPipelineStep}}. For an example pipeline, see 
\code{\link{scrna_pipeline}}.
}
