% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{graphMng}
\alias{graphMng}
\alias{addEdges}
\alias{getPrevSteps}
\alias{getAttachedStep}
\alias{regAttachedStep}
\alias{getNextSteps}
\alias{printMap}
\title{Step graph management}
\usage{
addEdges(edges, argOrder)

getPrevSteps(stepType, argOrder)

getAttachedStep(stepType)

regAttachedStep(newStepType, stepType)

getNextSteps(stepType, argOrder)

printMap(stepType = NULL, display = TRUE, ...)
}
\arguments{
\item{edges}{\code{Character} vector.
Contain the names of start and end points for all edges.
It needs to follow the format like c("startpt1","endpt1","startpt2",
"endpt2","startpt3","endpt3").}

\item{argOrder}{\code{Numeric} scalar.
The argument order of the input Step object.}

\item{stepType}{\code{Character} scalar.
Step class name of each step.}

\item{newStepType}{\code{Logical} scalar.
give a new step step type name to the original step type with
 different default parameter value}

\item{display}{\code{Logical} scalar.
Wether show the picture on device or not.}

\item{...}{Additional arguments, currently used.}
}
\value{
\item{addEdges}{No value will be returned.}

\item{getPrevSteps}{Names of previous steps}

\item{getAttachedStep}{get the step that is generated from}

\item{regAttachedStep}{Add different step type for exist step}

\item{getNextSteps}{Names of next steps}

\item{printMap}{Print the flow map for the pipeline.}
}
\description{
The step relations are managed and restricted
to directed acyclic graph. The direction of data flow is
from upstream to downstream. So when users create a new step object,
restricting its relation with existing steps is necessary.
}
\examples{
addEdges(edges = c("RandomRegionOnGenome",
                   "OverlappedRandomRegion"),argOrder = 1)
printMap()

getPrevSteps("OverlappedRandomRegion",1)

}
