% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_domain_annotation.R
\name{annotate_pfam}
\alias{annotate_pfam}
\title{Annotate proteins sequences with PFAM domains}
\usage{
annotate_pfam(seq = NULL, evalue = 1e-05)
}
\arguments{
\item{seq}{An AAStringSet object as returned
by \code{Biostrings::readAAStringSet()}. The sequences in this object must
represent only the translated sequences of primary (or longest) transcripts.}

\item{evalue}{Numeric indicating the E-value threshold for hmmsearch
to be used for domains without pre-defined domain cutoffs.
Only valid if parameter mode = 'local'. Default: 1e-05.}
}
\value{
A 2-column data frame with the variables \strong{Gene}
and \strong{Domain}, which contain gene IDs and domain IDs, respectively.
}
\description{
PFAM domains are assigned to each sequence using HMMER.
}
\examples{
data(gsu)
seq <- gsu[1:5]
if(hmmer_is_installed()) {
    annotate_pfam(seq)
}
}
