% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{dplyr-rename}
\alias{dplyr-rename}
\alias{rename.GInteractions}
\title{Rename columns from a GInteractions with tidyverse-like \code{rename}}
\usage{
\method{rename}{GInteractions}(.data, ...)
}
\arguments{
\item{.data}{a GInteractions object}

\item{...}{\if{html}{\out{<tidy-select>}} Use \code{new_name = old_name} to
rename selected variables.}
}
\value{
a GInteractions object.
}
\description{
Rename columns from a GInteractions with tidyverse-like \code{rename}
}
\examples{
gi <- read.table(text = "
chr1 10 20 chr1 50 51
chr1 10 50 chr2 30 40",
col.names = c("chr1", "start1", "end1", "chr2", "start2", "end2")) |> 
  as_ginteractions(seqnames1 = chr1, seqnames2 = chr2) |> 
  mutate(type = c('cis', 'trans'), score = runif(2))
  
####################################################################
# 1. Rename metadata columns to a GInteractions object
####################################################################

gi |> rename(interaction_type = type, GC = score)

}
