% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{processing_history}
\alias{processing_history}
\title{Return history of applied functions and argument from pmp package.}
\usage{
processing_history(df)
}
\arguments{
\item{df}{A matrix-like (e.g. an ordinary matrix, a data frame) or 
\link[SummarizedExperiment]{RangedSummarizedExperiment-class} object with 
all values of class \code{numeric()} or \code{integer()} of peak 
intensities, areas or other quantitative characteristic.}
}
\value{
List of function  names and argument values.
}
\description{
Return history of applied functions and argument from pmp package.
}
\examples{
df <- MTBLS79[ ,MTBLS79$Batch == 1]
df$Class[1:2] <- "Blank"
out <- filter_peaks_by_blank(df=df, fold_change=1.2, 
   classes=df$Class, blank_label="Blank", qc_label=NULL, 
   remove_samples=FALSE, remove_peaks=TRUE, fraction_in_blank=0)
processing_history(out)

}
