% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEmbeddingMetrics.R
\name{getEmbeddingClassMetrics}
\alias{getEmbeddingClassMetrics}
\title{getEmbeddingClassMetrics}
\usage{
getEmbeddingClassMetrics(
  x,
  labels,
  metrics = c("meanSW", "minSW", "pnSW", "dbcv"),
  distance = "euclidean",
  ...
)
}
\arguments{
\item{x}{A data.frame or matrix (with features as columns and items as rows)
from which the metrics will be computed.}

\item{labels}{A vector containing the labels of the predicted clusters. Must
be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{metrics}{The metrics to compute.}

\item{distance}{The distance metric to use (default euclidean).}

\item{...}{Optional arguments. See details.}
}
\value{
A data.frame of metrics for each node/element of \code{x}.
}
\description{
Computes class-level, embedding-based metrics.
}
\keyword{internal}
