% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialMetrics.R
\name{getNeighboringPairConcordance}
\alias{getNeighboringPairConcordance}
\title{Per-element local concordance between a clustering and a ground truth}
\usage{
getNeighboringPairConcordance(
  true,
  pred,
  location,
  k = 20L,
  useNegatives = FALSE,
  distWeights = TRUE,
  BNPARAM = NULL
)
}
\arguments{
\item{true}{A vector of true class labels}

\item{pred}{A vector of predicted clusters}

\item{location}{A matrix or data.frame with spatial dimensions as columns.
Alternatively, a nearest neighbor object as produced by
\code{\link[BiocNeighbors]{findKNN}}.}

\item{k}{Approximate number of nearest neighbors to consider}

\item{useNegatives}{Logical; whether to include the concordance of negative
pairs in the score (default FALSE).}

\item{distWeights}{Logical; whether to weight concordance by distance
(default TRUE).}

\item{BNPARAM}{A BiocNeighbors parameter object to compute kNNs. Ignored
unless the input is a matrix or data.frame. If omitted, the Annoy
approximation will be used if there are more than 500 elements.}
}
\value{
A vector of concordance scores
}
\description{
Per-element local concordance between a clustering and a ground truth
}
\examples{
data(sp_toys)
data <- sp_toys
getNeighboringPairConcordance(data$label, data$p1, data[,c("x", "y")], k=6)
}
