/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import org.biojava.bio.dist.Distribution;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public interface ScoreType {
    public static final ScoreType PROBABILITY = new Probability();
    public static final ScoreType ODDS = new Odds();
    public static final ScoreType NULL_MODEL = new NullModel();

    public double calculateScore(Distribution var1, Symbol var2) throws IllegalSymbolException;

    public static class Probability
    implements ScoreType {
        public double calculateScore(Distribution distribution, Symbol symbol) throws IllegalSymbolException {
            return distribution.getWeight(symbol);
        }
    }

    public static class Odds
    implements ScoreType {
        public double calculateScore(Distribution distribution, Symbol symbol) throws IllegalSymbolException {
            double d = distribution.getWeight(symbol);
            double d2 = distribution.getNullModel().getWeight(symbol);
            return d / d2;
        }
    }

    public static class NullModel
    implements ScoreType {
        public double calculateScore(Distribution distribution, Symbol symbol) throws IllegalSymbolException {
            return distribution.getNullModel().getWeight(symbol);
        }
    }
}

