% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_diffSplicing_table.R
\name{createOptimalSurvData}
\alias{createOptimalSurvData}
\title{Create survival data based on a PSI cutoff}
\usage{
createOptimalSurvData(
  eventPSI,
  clinical,
  censoring,
  event,
  timeStart,
  timeStop,
  match,
  patients,
  samples
)
}
\arguments{
\item{eventPSI}{Numeric: alternative splicing quantification for multiple
samples relative to a single splicing event}

\item{clinical}{Data frame: clinical data}

\item{censoring}{Character: censor using \code{left}, \code{right},
\code{interval} or \code{interval2}}

\item{event}{Character: name of column containing time of the event of
interest}

\item{timeStart}{Character: name of column containing starting time of the
interval or follow up time}

\item{timeStop}{Character: name of column containing ending time of the
interval (only relevant for interval censoring)}

\item{match}{Matrix: match between samples and subjects}

\item{patients}{Character: subject identifiers (only required if the
\code{clinical} argument is not handed)}

\item{samples}{Character: samples to use when assigning values per subject
(if \code{NULL}, all samples will be used)}
}
\value{
Survival data including optimal PSI cutoff, minimal survival p-value
and HTML element required to plot survival curves
}
\description{
Data is presented in the table for statistical analyses
}
\keyword{internal}
