% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_miso.R
\name{parseMisoEvent}
\alias{parseMisoEvent}
\title{Parse an alternative splicing event from MISO}
\usage{
parseMisoEvent(event)
}
\arguments{
\item{event}{Data.frame containing only one event with at least 7 columns as 
retrieved from the alternative splicing annotation files from MISO (GFF3
files)}
}
\value{
List with event attributes and junction positions for the exons
(depends on the events)
}
\description{
Parse an alternative splicing event from MISO
}
\details{
More information about MISO available at
\url{http://miso.readthedocs.org}
}
\examples{
# example of alternative splicing event: skipped exon (SE)
event <- read.table(text = "
  chr1 SE gene 16854 18061 . - .
  chr1 SE mRNA 16854 18061 . - .
  chr1 SE exon 16854 17055 . - .
  chr1 SE exon 17233 17742 . - .
  chr1 SE exon 17915 18061 . - .
  chr1 SE mRNA 16854 18061 . - .
  chr1 SE exon 16854 17955 . - .
  chr1 SE exon 17915 18061 . - .")
psichomics:::parseMisoEvent(event)
}
\keyword{internal}
