% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_dimReduction_ica.R
\name{performICA}
\alias{performICA}
\title{Perform independent component analysis after processing missing values}
\usage{
performICA(
  data,
  n.comp = min(5, ncol(data)),
  center = TRUE,
  scale. = FALSE,
  missingValues = round(0.05 * nrow(data)),
  alg.typ = c("parallel", "defaltion"),
  fun = c("logcosh", "exp"),
  alpha = 1,
  ...
)
}
\arguments{
\item{data}{an optional data frame (or similar: see
    \code{\link[stats]{model.frame}}) containing the variables in the
    formula \code{formula}.  By default the variables are taken from
    \code{environment(formula)}.}

\item{n.comp}{number of components to be extracted}

\item{center}{a logical value indicating whether the variables
    should be shifted to be zero centered. Alternately, a vector of
    length equal the number of columns of \code{x} can be supplied.
    The value is passed to \code{scale}.}

\item{scale.}{a logical value indicating whether the variables should
    be scaled to have unit variance before the analysis takes
    place.  The default is \code{FALSE} for consistency with S, but
    in general scaling is advisable.  Alternatively, a vector of length
    equal the number of columns of \code{x} can be supplied.  The
    value is passed to \code{\link{scale}}.}

\item{missingValues}{Integer: number of tolerated missing values per column
to be replaced with the mean of the values of that same column}

\item{alg.typ}{if \code{alg.typ == "parallel"} the components are extracted
    simultaneously (the default). if \code{alg.typ == "deflation"} the
    components are extracted one at a time.}

\item{fun}{the functional form of the \eqn{G} function used in the
    approximation to neg-entropy (see \sQuote{details}).}

\item{alpha}{constant in range [1, 2] used in approximation to
    neg-entropy when \code{fun == "logcosh"}}

\item{...}{Arguments passed on to \code{fastICA::fastICA}}
}
\value{
ICA result in a \code{prcomp} object
}
\description{
Perform independent component analysis after processing missing values
}
\examples{
performICA(USArrests)
}
\seealso{
Other functions to analyse independent components: 
\code{\link{plotICA}()}
}
\concept{functions to analyse independent components}
