% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_firebrowse.R
\name{queryFirebrowseData}
\alias{queryFirebrowseData}
\title{Query the FireBrowse API for TCGA data}
\usage{
queryFirebrowseData(
  format = "json",
  date = NULL,
  cohort = NULL,
  data_type = NULL,
  tool = NULL,
  platform = NULL,
  center = NULL,
  level = NULL,
  protocol = NULL,
  page = NULL,
  page_size = NULL,
  sort_by = NULL
)
}
\arguments{
\item{format}{Character: response format as \code{JSON}, \code{CSV} or
\code{TSV}}

\item{date}{Character: dates of the data retrieval by FireBrowse (by default,
it uses the most recent data available)}

\item{cohort}{Character: abbreviation of the cohorts (by default, returns
data for all cohorts)}

\item{data_type}{Character: data types (optional)}

\item{tool}{Character: data produced by the selected FireBrowse tools
(optional)}

\item{platform}{Character: data generation platforms (optional)}

\item{center}{Character: data generation centres (optional)}

\item{level}{Integer: data levels (optional)}

\item{protocol}{Character: sample characterization protocols (optional)}

\item{page}{Integer: page of the results to return (optional)}

\item{page_size}{Integer: number of records per page of results (optional)}

\item{sort_by}{String: column used to sort the data (by default, sort by
cohort)}
}
\value{
Response from the FireBrowse API (it needs to be parsed)
}
\description{
Query the FireBrowse API for TCGA data
}
\examples{
cohort <- getTCGAcohorts()[1]
psichomics:::queryFirebrowseData(cohort = names(cohort),
                                 data_type = "mRNASeq")

# Querying for data from a specific date
dates <- getTCGAdates()
dates <- format(dates, psichomics:::getFirebrowseDateFormat()$query)

psichomics:::queryFirebrowseData(date = dates[2], cohort = names(cohort))
}
\keyword{internal}
