% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalAccess.R
\name{getGroups}
\alias{getGroups}
\alias{setGroups}
\title{Get or set groups}
\usage{
getGroups(
  type = c("Patients", "Samples", "ASevents", "Genes"),
  complete = FALSE,
  category = getCategory()
)

setGroups(
  type = c("Patients", "Samples", "ASevents", "Genes"),
  groups,
  category = getCategory()
)
}
\arguments{
\item{type}{Character: type of groups (either \code{Patients},
\code{Samples}, \code{ASevents} or \code{Genes})}

\item{complete}{Boolean: return all the information on groups (\code{TRUE})
or just the group names and respective indexes (\code{FALSE})?}

\item{category}{Character: data category}

\item{groups}{Matrix: groups of dataset}
}
\value{
Getters return globally accessible data, whereas setters return
\code{NULL} as they are only used to modify the Shiny session's state
}
\description{
Get or set groups
}
\note{
Needs to be called inside a reactive function
}
\seealso{
Other functions to get and set global variables: 
\code{\link{getClinicalMatchFrom}()},
\code{\link{getDifferentialExpression}()},
\code{\link{getDifferentialSplicing}()},
\code{\link{getGlobal}()},
\code{\link{getHighlightedPoints}()},
\code{\link{getSelectedDataPanel}()}
}
\concept{functions to get and set global variables}
\keyword{internal}
