% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hchart.survfit}
\alias{hchart.survfit}
\title{Plot survival curves}
\usage{
\method{hchart}{survfit}(
  object,
  ...,
  fun = NULL,
  markTimes = TRUE,
  symbol = "plus",
  markerColor = "black",
  ranges = FALSE,
  rangesOpacity = 0.3
)
}
\arguments{
\item{object}{\code{survfit} object as returned from
\code{\link{survfit.survTerms}()} function}

\item{...}{
  Arguments passed on to \code{\link[highcharter:hc_add_series]{highcharter::hc_add_series}}
  \describe{
    \item{\code{}}{}
  }}

\item{fun}{Name of function or function used to transform the survival curve:
\code{log} will put y axis on log scale, \code{event} plots cumulative events
(f(y) = 1-y), \code{cumhaz} plots the cumulative hazard function (f(y) =
-log(y)), and \code{cloglog} creates a complimentary log-log survival plot
(f(y) = log(-log(y)) along with log scale for the x-axis.}

\item{markTimes}{Label curves marked at each censoring time?}

\item{symbol}{Symbol to use as marker}

\item{markerColor}{Colour of the marker; if \code{NULL}, the respective
colour of each series are used}

\item{ranges}{Plot interval ranges?}

\item{rangesOpacity}{Opacity of the interval ranges}
}
\value{
\code{highchart} object to plot survival curves
}
\description{
Plot survival curves
}
\examples{

# Plot Kaplan-Meier curves
require("survival")
require("highcharter")
leukemia.surv <- survfit(Surv(time, status) ~ x, data = aml)
hchart(leukemia.surv)

# Plot the cumulative hazard function
lsurv2 <- survfit(Surv(time, status) ~ x, aml, type='fleming')
hchart(lsurv2, fun="cumhaz")

# Plot the fit of a Cox proportional hazards regression model
fit <- coxph(Surv(futime, fustat) ~ age, data = ovarian)
ovarian.surv <- survfit(fit, newdata=data.frame(age=60))
hchart(ovarian.surv, ranges = TRUE)
}
\keyword{internal}
