% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{leveneTest}
\alias{leveneTest}
\title{Levene's test}
\usage{
leveneTest(x, g, centers = median)
}
\arguments{
\item{x}{Numeric vector or list of numeric vectors: non-numeric elements of a
list will be coerced with a warning}

\item{g}{Vector or factor: groups of elements in \code{x} (ignored with a
warning if \code{x} is a list)}

\item{centers}{Function used to calculate how much values spread; for
instance, \code{median} (default) or \code{mean}}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{the value of the test statistic with a name describing it.}
\item{p.value}{the p-value for the test.}
\item{method}{the type of test applied.}
\item{data.name}{a character string giving the names of the data.}
}
\description{
Performs a Levene's test to assess the equality of variances
}
\details{
The implementation of this function is based on
\code{car:::leveneTest.default} with a more standard result.
}
\examples{

vals <- sample(30, replace=TRUE)
group <- lapply(list("A", "B", "C"), rep, 10)
group <- unlist(group)
psichomics:::leveneTest(vals, group)

## Using Levene's test based on the mean
psichomics:::leveneTest(vals, group, mean)
}
\keyword{internal}
