% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_dimReduction_ica.R
\name{plotSingleICA}
\alias{plotSingleICA}
\title{Create a scatterplot for ICA}
\usage{
plotSingleICA(ica, icX = 1, icY = 2, groups = NULL)
}
\arguments{
\item{ica}{Object containing an ICA}

\item{icX}{Character: name of the X axis}

\item{icY}{Character: name of the Y axis}

\item{groups}{Matrix: groups to plot indicating the index of interest of the
samples (use clinical or sample groups)}
}
\value{
Scatterplot as an \code{highcharter} object
}
\description{
Create a scatterplot for ICA
}
\examples{
ica <- performICA(USArrests, scale=TRUE)
psichomics:::plotSingleICA(ica)
psichomics:::plotSingleICA(ica, icX=2, icY=3)

# Colour by groups
groups <- NULL
groups$sunny <- c("California", "Hawaii", "Florida")
groups$ozEntrance <- c("Kansas")
groups$novel <- c("New Mexico", "New York", "New Hampshire", "New Jersey")
psichomics:::plotSingleICA(ica, groups=groups)
}
\keyword{internal}
