% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMiss.R
\name{plotMiss}
\alias{plotMiss}
\title{Missing value plot}
\usage{
plotMiss(
  x,
  i,
  group,
  dendrogram_row = TRUE,
  dendrogram_col = FALSE,
  colors = (scales::viridis_pal())(2),
  hide_colorbar = TRUE,
  showticklabels = c(TRUE, FALSE),
  row_dend_left = FALSE,
  k_row = 1,
  k_col = 1,
  ...
)
}
\arguments{
\item{x}{A matrix-like object or \linkS4class{SummarizedExperiment} object.}

\item{i}{A string or integer value specifying which assay values to use
when \code{x} is a SummarizedExperiment object.}

\item{group}{A discrete variable to change colors of the barplot by sample
groups.}

\item{dendrogram_row}{A logical specifying whether dendogram is computed and
reordering is performed based on rows.}

\item{dendrogram_col}{A logical specifying whether dendogram is computed and
reordering is performed based on columns.}

\item{colors}{A vector of colors for the heatmap.}

\item{hide_colorbar}{A logical specifying whether the color bar (legend) in
the heatmap is hidden.}

\item{showticklabels}{A logical vector of length 2 (x-axis, y-axis)
specifying whether the ticks are removed from the sides of the heatmap.}

\item{row_dend_left}{A logical controlling whether the row dendrogram is
placed on the left on the heatmap.}

\item{k_row}{A numeric value specifying the desired number of groups by
which to color the dendrogram's branches in the rows. If \code{NA}, then
\link[dendextend:find_k]{dendextend::find_k} is used to deduce the optimal number of clusters.}

\item{k_col}{A numeric value specifying the desired number of groups by
which to color the dendrogram's branches in the columns. If \code{NA}, then
\link[dendextend:find_k]{dendextend::find_k} is used to deduce the optimal number of clusters.}

\item{...}{Additional arguments passed to \link[heatmaply:heatmaply]{heatmaply::heatmaply}.}
}
\value{
A patchwork object of aligned ggplots
}
\description{
Visualizes missing values with a \link{SummarizedExperiment} object or
matrix of intensity data where rows represent features and columns represent
samples. All values in a data matrix are re-coded (1: missing; 0:
non-missing). The left panel displays the amount of missing values in each
samples. The right panel displays the pattern of missing values using a
heatmap with dendrograms.
}
\examples{

data(faahko_se)

## Sample group
g <- colData(faahko_se)$sample_group

## SummarizedExperiment object
plotMiss(faahko_se, i = 1, group = g)

## Matrix
m <- assay(faahko_se, i = 1)
plotMiss(m, group = g, dendrogram_col = TRUE)

}
\references{
Tal Galili, Alan O'Callaghan, Jonathan Sidi, Carson Sievert;
heatmaply: an R package for creating interactive cluster heatmaps for
online publishing, Bioinformatics, btx657,
https://doi.org/10.1093/bioinformatics/btx657
}
