% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{qsmoothData}
\alias{qsmoothData}
\alias{qsmoothData,qsmooth-method}
\title{Generic function that returns the qsmooth normalized data}
\usage{
qsmoothData(object)

\S4method{qsmoothData}{qsmooth}(object)
}
\arguments{
\item{object}{an object of class \code{qsmooth}.}
}
\value{
The normalized data after applying 
smoothed quantile normalization.
}
\description{
Given a qsmooth object, this function returns the 
qsmooth normalized data

Accessors for the 'qsmoothData' slot of a qsmooth object.
}
\examples{
dat <- cbind(matrix(rnorm(1000), nrow=100, ncol=10), 
             matrix(rnorm(1000, .1, .7), nrow=100, ncol=10))
dat_qs <- qsmooth(object = dat, 
                  group_factor = rep(c(0,1), each=10))
qsmoothData(dat_qs)

}
