#' PCs from transcripts
#'
#'  This function returns the pcs from the obtained RangedSummarizedExperiment object of selected transcripts
#'
#'
#' @param rse_tx Ranged Summarizeed Experiment with only trancsripts selected for qsva
#' @param assayname character string specifying the name of the assay desired in rse_tx
#'
#' @return prcomp object generated by taking the pcs of degraded transcripts
#' @export
#' @importFrom stats prcomp
#' @import SummarizedExperiment
#' @examples
#' getPCs(rse_tx, "tpm")
getPCs <- function(rse_tx, assayname = "tpm") {
    # Validate rse_tx is a RangedSummarizedExperiment object
    if (!is(rse_tx, "RangedSummarizedExperiment")) {
        stop("'rse_tx' must be a RangedSummarizedExperiment object.", call. = FALSE)
    }

    # Check if assayname is in assayNames
    if (!assayname %in% assayNames(rse_tx)) {
        stop(sprintf("'%s' is not in assayNames(rse_tx).", assayname), call. = FALSE)
    }
    # Compute PCs
    qsvPCs <- prcomp(t(log2(assays(rse_tx)[[assayname]] + 1)))
}
