% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{methods}
\name{show}
\alias{show}
\alias{quantro}
\title{quantro}
\usage{
quantro(
  object,
  groupFactor = NULL,
  B = 0,
  qRange = NULL,
  useMedianNormalized = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{object}{an object which is inherited from an 
\code{eSet} such as an \code{ExpressionSet} or 
\code{MethylSet} object. The \code{object} can also be a 
data frame or matrix with observations
(e.g. probes or genes) on the rows and samples as the 
columns.}

\item{groupFactor}{a group level factor associated with 
each sample or column in the \code{object}. The order of the
\code{groupFactor} must match the order of the columns in
\code{object}.}

\item{B}{number of permutations to assess statistical significance 
in a permutation test. Default \code{B}=0.}

\item{qRange}{the range of quantiles to consider. Default is 
\code{seq(0, 1, length.out = nrow(object))}.}

\item{useMedianNormalized}{TRUE/FALSE argument specifying if the 
median normalized data should be used or not as input to test for 
global differences between distributions. Default is TRUE.}

\item{verbose}{TRUE/FALSE argument specifying if verbose messages 
should be returned or not. Default is TRUE.}
}
\value{
A \code{quantro} S4 class object
\item{summary}{Returns a list of three elements 
related to a summary of the experiment: 
(1) the number of groups (nGroups), 
(2) total number of samples (nTotSamples), 
(3) number of samples in each group (nSamplesinGroups).}
\item{B}{Number of permutations for permutation testing.}
\item{anova}{ANOVA to test if the medians of the 
distributions (averaged across groups) are different across groups.}
\item{quantroStat}{A test statistic which is a ratio of the mean squared 
error between groups of distributions to the mean squared error within 
groups of distributions (psuedo F-statistic).}
\item{quantroStatPerm}{If \code{B} is not equal to 0, then a permutation 
test was performed to assess the statistical significance of \code{quantroStat}. 
These are the test statistics resulting from the permuted samples.}
\item{quantroPvalPerm}{If \code{B} is not equal to 0, then this is the 
p-value associated with the proportion of times the test statistics 
resulting from the permuted samples were larger than \code{quantroStat}.}
}
\description{
This is a function that tests for global differences between 
groups of distributions which asses whether global normalization 
methods such as quantile normalization should be applied. 
This function defines the quantro class and constructor.
}
\details{
Quantile normalization is one of the most widely used normalization tools 
for data analysis in genomics. Although it was originally developed for 
gene expression microarrays it is now used across many different 
high-throughput applications including RNAseq and ChIPseq. The methodology 
relies on the assumption that observed changes in the empirical 
distribution of samples are due to unwanted variability. Because the data is 
transformed to remove these differences it has the potential to remove 
interesting biologically driven global variation. Therefore, applying 
quantile normalization, or other global normalization methods
that rely on similar assumptions, may not be an appropriate depending 
on the type and source of variation. 

This function can be used to test a priori to the data analysis whether 
global normalization methods such as quantile normalization should be 
applied. The \code{quantro} function uses the raw unprocessed high-throughput 
data to test for global differences in the distributions across a set of groups. 

The \code{quantro} function will perform two tests:

1. An ANOVA to test if the medians of the distributions are different across 
groups. Differences across groups could be attributed to unwanted technical 
variation (such as batch effects) or real global biological variation. 
This is a helpful step for the user to verify if there is some unaccounted
technical variation. 

2. A test for global differences between the distributions across groups.
The main output is a test statistic called \code{quantroStat}. This test 
statistic is a ratio of two variances and is similar to the idea of ANOVA. 
The main idea of the test is to compare the variability of distributions 
within the groups to the variability of distributions between the groups. 
If the variance between the groups is sufficiently larger than the variance 
within the groups, quantile normalization may not be an appropriate 
normalization technique depending on the source of variation 
(technical or biological variation). As a default, we perform this test on 
after a median normalization, but this option may be changed.

To assess the statistical significance of \code{quantroStat}, we use 
permutation testing. To perform a permutation test, set \code{B} to the 
number of permutations which will create a null distribution.  If the number
of samples is large, this number can be a large number such as 1000. This 
step can be very slow, but a parallelization has been implemented 
throught the \code{foreach} package. Register the number of cores using 
the \code{doParallel} package. 

See the vignette for more details.
}
\examples{
library(minfi)
data(flowSorted)
p <- getBeta(flowSorted, offset = 100)
pd <- pData(flowSorted)

qtest <- quantro(object = p, groupFactor = pd$CellType)

}
