% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Methods.R
\name{extractHDV}
\alias{extractHDV}
\alias{extractHDV,AAStringSet-method}
\alias{extractHDV,DNAStringSet-method}
\alias{extractHDV,RNAStringSet-method}
\alias{extractHDV,BStringSet-method}
\alias{extractHDV,BString-method}
\alias{extractHDV,character-method}
\title{Function for obtaining the HDV (High Dimensional Vector) matrix}
\usage{
extractHDV(input, mask = NULL, seqtype = "AA", ...)

\S4method{extractHDV}{AAStringSet}(
  input,
  mask = NULL,
  seqtype = NULL,
  bin = FALSE,
  concatenate = FALSE,
  verbose = TRUE
)

\S4method{extractHDV}{DNAStringSet}(
  input,
  mask = NULL,
  seqtype = NULL,
  bin = FALSE,
  concatenate = FALSE,
  verbose = TRUE
)

\S4method{extractHDV}{RNAStringSet}(
  input,
  mask = NULL,
  seqtype = NULL,
  bin = FALSE,
  concatenate = FALSE,
  verbose = TRUE
)

\S4method{extractHDV}{BStringSet}(
  input,
  mask = NULL,
  seqtype = NULL,
  bin = FALSE,
  concatenate = FALSE,
  verbose = TRUE
)

\S4method{extractHDV}{BString}(
  input,
  mask = NULL,
  seqtype = NULL,
  bin = FALSE,
  concatenate = FALSE,
  verbose = TRUE
)

\S4method{extractHDV}{character}(
  input,
  mask = NULL,
  seqtype = "AA",
  bin = FALSE,
  extension = "",
  verbose = TRUE
)
}
\arguments{
\item{input}{There are two input formats available:
(a) `BStringSet' (variants: `AAStringSet', `RNAStringSet', `DNAStringSet'). Biological sequence format loaded in memory;
(b) `character'. String containing a path to a folder with FASTA files.}

\item{mask}{readging mask. Default for amino acids is `c(2,1,2)` and for nucleotides c(5,5,5)#'}

\item{seqtype}{type of data: AA for amino acid, NT for nucleotide. The default is `AA`}

\item{...}{other arguments of the function itself}

\item{bin}{binary mode (TRUE), or counting mode (FALSE) for HDV construction. Default is FALSE}

\item{concatenate}{defines whether to treat each sequence individually or to concatenate them into a single sequence. 
Available only for inputs in biological sequence format. The default is FALSE.}

\item{verbose}{verbose mode. The default is TRUE}

\item{extension}{extension of files desired to concatenate (Optional).   Available only for input type path to folder with FASTA files.}
}
\value{
`extractHDV' returns a `list` containing:
\itemize{
  \item HDV: a `matrix' containing the High Dimensional Vectors of the given FASTAS
  \item info: aditional information of the process. This object is subdivided in: 
  \itemize{
      \item headers: a `character' containing the list of samples 
      \item mask: a `integer' containing the mask used
      \item SequenceType: a `character' containing the type of the sequence (amino acid: AA, ou nucleotide: NT)
      \item extension: a `character' containing the list of extensions considered
      \item concatenate : a boolean corresponding to the concatenation of sequences
      \item bin: a `character' containing if binary or counting
      \item version : a character corresponding to the version of the package
      \item saturation: a `vector' containing the filled (non-zero) percentage of the HDV for each sample
      \item timeElapsed: a `double' containing the elapsed time in seconds
   } 
}
}
\description{
Function for obtaining the HDV matrix without projecting it low dimensional vector (LDV). 
Each line of the HDV corresponds to the counting of k-mers of a biological sequence, 
organized in a structured way.
}
\examples{

# get the path to the folder containing the FASTA files
path = paste (system.file("examples/aaMitochondrial/",package = "rSWeeP"),'/', sep = '')

# define the parameters
mask = c(2,1,2)

# get the vectors that represent the sequences in high dimension (without projection)
HDV = extractHDV(input=path,mask=mask,seqtype='AA',bin=FALSE,extension=c('.faa','.fas','.fasta'))


}
