% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R, R/accessors.R, R/show.R
\docType{class}
\name{ScudoResults-class}
\alias{ScudoResults-class}
\alias{ScudoResults}
\alias{distMatrix}
\alias{distMatrix,ScudoResults-method}
\alias{upSignatures}
\alias{upSignatures,ScudoResults-method}
\alias{downSignatures}
\alias{downSignatures,ScudoResults-method}
\alias{groupsAnnotation}
\alias{groupsAnnotation,ScudoResults-method}
\alias{consensusUpSignatures}
\alias{consensusUpSignatures,ScudoResults-method}
\alias{consensusDownSignatures}
\alias{consensusDownSignatures,ScudoResults-method}
\alias{selectedFeatures}
\alias{selectedFeatures,ScudoResults-method}
\alias{scudoParams}
\alias{scudoParams,ScudoResults-method}
\alias{show,ScudoResults-method}
\title{Class ScudoResults}
\description{
This is an S4 class that represents the output of the functions
\code{\link{scudoTrain}} and \code{\link{scudoTest}}.
}
\details{
This class provides a structure to represent the results of \code{scudoTrain}
and \code{scudoTest}. It contains the distance matrix and the gene signatures
generated by the SCUDO analysis. It is possible, although not recommended, to
manually create instances of this class (see Examples below).
}
\section{Slots}{

\describe{
\item{\code{distMatrix}}{a symmetric matrix with
non-negative numeric elements}

\item{\code{upSignatures}}{a data.frame with the
same colnames as distMatrix, representing the up-regualted features in each
sample}

\item{\code{downSignatures}}{a data.frame with the
same colnames as distMatrix, representing the down-regualted
features in each sample}

\item{\code{groupsAnnotation}}{a factor that represents the groups
used for the computeFC and the feature selection}

\item{\code{consensusUpSignatures}}{a data.frame that contains the
consensus signatures of up-regulated features for each group}

\item{\code{consensusDownSignatures}}{a data.frame that contains
the consensus signatures of dowm-regulated features for each group}

\item{\code{selectedFeatures}}{a character vector of selected
features. If the feature selection was not performed, it contains every
feature present in the input of the scudo functions}

\item{\code{scudoParams}}{a list of the parameters used to run
the function that created the instance of the class}
}}

\section{Methods}{

\describe{
\item{\code{distMatrix}}{\code{signature(object = "ScudoResults")}:
a method for obtaining the distance matrix.}
\item{\code{upSignatures}}{\code{signature(object = "ScudoResults")}: a
method for obtaining the signature of up-regualted features in each
sample.}
\item{\code{downSignatures}}{\code{signature(object =
"ScudoResults")}: a method for obtaining the signature of down-regulated
features in each sample.}
\item{\code{groupsAnnotation}}{\code{signature(object = "ScudoResults")}:
a method for obtaining the groups used for
computeFC and feature selection.}
\item{\code{consensusUpSignatures}}{\code{signature(object =
"ScudoResults")}: a method for obtaining the consensus signatures of
up-regualted features in each group.}
\item{\code{consensusDownSignatures}}{\code{signature(object =
"ScudoResults")}: a method for obtaining the consensus signatures of
down-regulated features in each group.}
\item{\code{selectedFeatures}}{\code{signature(object = "ScudoResults")}:
a method for obtaining the names of the features seleted. If no feature
selection was performed, the names of every feature are returned.}
\item{\code{scudoParams}}{\code{signature(object = "ScudoResults")}: a method
for obtaining the parameters that were used to generate the result.}
}
}

\examples{

# manually generate instance of ScudoResults class
m <- matrix(1, ncol = 4, nrow = 4)
diag(m) <- 0
rownames(m) <- colnames(m) <- letters[1:4]
SigUp <- data.frame(a = letters[1:5], b = letters[6:10], c = letters[11:15],
    d = letters[16:20], stringsAsFactors = FALSE)
SigDown <- data.frame(a = letters[1:10], b = letters[11:20],
    c = letters[1:10], d = letters[11:20],
    stringsAsFactors = FALSE)
groups <- as.factor(c("G1", "G1", "G2", "G2"))
ConsUp <- data.frame(G1 = letters[11:15], G2 = letters[21:25],
    stringsAsFactors = FALSE)
ConsDown <- data.frame(G1 = letters[16:25], G2 = letters[1:10],
    stringsAsFactors = FALSE)
Feats <- letters[1:20]
Pars <- list()

scudoR <- ScudoResults(distMatrix = m,
    upSignatures = SigUp,
    downSignatures = SigDown,
    groupsAnnotation = groups,
    consensusUpSignatures = ConsUp,
    consensusDownSignatures = ConsDown,
    selectedFeatures = Feats,
    scudoParams = Pars)

}
\author{
Matteo Ciciani \email{matteo.ciciani@gmail.com}, Thomas Cantore
\email{cantorethomas@gmail.com}
}
