% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{plotCycleTime}
\alias{plotCycleTime}
\alias{PlotCycleTime}
\title{Plot Cycle Time}
\usage{
plotCycleTime(x, method = "trellis")
}
\arguments{
\item{x}{a \code{data.frame} object adhering to the specified criteria for
the \code{is.rawDiag} function.}

\item{method}{specifying the plot method 'trellis' | 'violin' | 'overlay'.
The default is 'trellis'.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
graphs the time difference between two consecutive MS1 scans
(cycle time) with respect to RT (scatter plots) or its density (violin).
A smooth curve graphs the trend. The 95th percentile is indicated by a red
dashed line.
}
\examples{
rawrr::sampleFilePath() |> rawDiag::readRaw() |> rawDiag::plotCycleTime()
}
