% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_plotCovar.R
\name{plotCovar}
\alias{plotCovar}
\title{Plot an the corvariance matrix of the test statistics estimated through permutations}
\usage{
plotCovar(
  reconsiFit,
  col = colorRampPalette(c("yellow", "blue"))(12),
  xlab = "Test statistic index",
  ylab = xlab,
  ...
)
}
\arguments{
\item{reconsiFit}{The reconsi fit}

\item{col, xlab, ylab, ...}{A list of arguments for the image() function.}
}
\value{
invisible()
}
\description{
Plot an the corvariance matrix of the test statistics estimated through permutations
}
\details{
By default, yellow indicates negative correlaton between test statistics,
blue positive correlation
}
\note{
Note the difference with the plotApproxCovar function, where the
covariances between binned test statistics are shown to get an idea between
covariances between tail and center values of the univariate null distribution.
Here the covariance matrix between all test statistics is shown
}
\examples{
p = 200; n = 50; B = 5e1
x = rep(c(0,1), each = n/2)
mat = cbind(
matrix(rnorm(n*p/10, mean = 5+x),n,p/10), #DA
matrix(rnorm(n*p*9/10, mean = 5),n,p*9/10) #Non DA
)
mat = mat = mat + rnorm(n, sd = 0.3) #Introduce some dependence
fdrRes = reconsi(mat, x, B = B)
plotCovar(fdrRes)
}
\seealso{
\link{plotApproxCovar}
}
