% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_regional_pcs.R
\name{combine_results}
\alias{combine_results}
\title{Combine results dataframes across regions}
\usage{
combine_results(res, df_name)
}
\arguments{
\item{res}{List of lists; contains summarized region results}

\item{df_name}{String;
name of result being combined (sig_pcs or percent_var)}
}
\value{
Data Frame containing results
}
\description{
Combine results dataframes across regions
}
\examples{
# Create example data for 'sig_pcs' and 'percent_var'
    sig_pcs_example <- data.frame(pcs = c("PC1", "PC2"),
value = c(0.2, 0.4))
percent_var_example <- data.frame(pcs = c("PC1", "PC2"),
value = c(0.7, 0.3))

# Create 'res' list containing both 'sig_pcs' and 'percent_var'
res <- list(region = "Region1", sig_pcs = sig_pcs_example,
percent_var = percent_var_example)

# Example function use: Combine 'sig_pcs' across regions
combined_sig_pcs <- combine_results(res, df_name = "sig_pcs")
print(combined_sig_pcs)
}
