% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.localZScoreResults.R
\name{plot.localZScoreResults}
\alias{plot.localZScoreResults}
\title{Plot localZscore results}
\usage{
\method{plot}{localZScoreResults}(x, main = "", num.x.labels = 5, ...)
}
\arguments{
\item{x}{an object of class \code{localZScoreResults}.}

\item{main}{a character specifying the main title of the plot. Defaults to no title.}

\item{num.x.labels}{a numeric specifying the number of ticks to label the x axis. The total number will be 2*num.x.labels + 1. Defaults to 5.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A plot is created on the current graphics device.
}
\description{
Function for plotting the a \code{localZScoreResults} object.
}
\examples{

genome <- filterChromosomes(getGenome("hg19"), keep.chr="chr1")
A <- createRandomRegions(nregions=20, length.mean=10000000, length.sd=20000, genome=genome, non.overlapping=FALSE) 
B <- c(A, createRandomRegions(nregions=10, length.mean=100000, length.sd=20000, genome=genome, non.overlapping=FALSE))

pt <- overlapPermTest(A=A, B=B, ntimes=10, genome=genome, non.overlapping=FALSE)
 
lz <- localZScore(A=A, B=B, pt=pt)
plot(lz)

}
\seealso{
\code{\link{localZScore}}
}
