% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plotMissings}
\alias{plotMissings}
\title{It draws a chart with the percentage of missing in an ExposomeSet}
\usage{
plotMissings(object, set, x.max = 100, sort = TRUE)
}
\arguments{
\item{object}{\link{ExposomeSet} which exposome will be plotted.}

\item{set}{Can be set to \code{"exposures"} or to \code{"phenotypes"}.}

\item{x.max}{(default \code{100}) Fix the maxium value of the X-axis.}

\item{sort}{(default \code{TRUE}) If \code{TRUE} the chart will be ordered
from the features with less missing data to the ones with more missing data.}
}
\value{
A \code{ggplot} object.
}
\description{
This function can be used to draw the number of missing data in exposures and
in phenotypes of an \link{ExposomeSet}.
}
\examples{
data("exposome")
# The included has no missing data
plotMissings(expo, set = "exposures")
plotMissings(expo, set = "phenotypes")
}
\seealso{
\link{plotFamily} to draw the profile of a family of exposures,
\link{plotHistogram} to draw the shape of an exposure,
\link{tableMissings} to get a table with the missing data of an ExposomeSet,
\link{imputation} to impute missing data on the exposures of an ExposomeSet
}
