% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateEditingTable.R
\name{CreateEditingTable}
\alias{CreateEditingTable}
\title{Convert RNA editing matrix into a special data frame with class
  \code{rnaEdit_df}.}
\usage{
CreateEditingTable(rnaEditMatrix)
}
\arguments{
\item{rnaEditMatrix}{A matrix of RNA editing level values on individual 
sites, with row names as site IDs in the form of "chrAA:XXXXXXXX", and 
column names as sample IDs. Please make sure to
follow the format of example dataset (\code{data(rnaedit_df)}).}
}
\value{
A dataset of class \code{rnaEdit_df}, includes variables 
  \code{seqnames, start, end, width} and summarized RNA editing levels in 
  each sample.
}
\description{
Convert RNA editing matrix to a special data frame with class 
  \code{rnaEdit_df}, which is then used to identify differentially co-edited
  regions with function \code{\link{TestAssociations}}.
}
\examples{
  data(rnaedit_df)
  CreateEditingTable(rnaEditMatrix = rnaedit_df)[1:3, 1:5]
  
}
\seealso{
\code{\link{TransformToGR}}, \code{\link{AllCloseByRegions}}, 
  \code{\link{AllCoeditedRegions}}, \code{\link{SummarizeAllRegions}}, 
  \code{\link{TestAssociations}}, \code{\link{AnnotateResults}}
}
