% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/px2.R
\name{PXDataset2}
\alias{PXDataset2}
\alias{class:PXDataset2}
\alias{PXDataset}
\alias{pxtitle}
\alias{pxfiles,PXDataset2-method}
\alias{pxfiles}
\alias{pxget,PXDataset2-method}
\alias{pxget}
\alias{pxid,PXDataset2-method}
\alias{pxid}
\alias{pxref,PXDataset2-method}
\alias{pxref}
\alias{pxtax,PXDataset2-method}
\alias{pxtax}
\alias{pxurl,PXDataset2-method}
\alias{pxurl}
\alias{show,PXDataset2-method}
\alias{pxCacheInfo,PXdataset-method}
\alias{pxCacheInfo}
\alias{pxinstruments}
\alias{pxSubmissionDate}
\alias{pxPublicationDate}
\alias{pxptms}
\alias{pxprotocols}
\alias{pxCacheInfo,PXDataset2-method}
\title{New PXDataset (v2) to find and download proteomics data}
\usage{
PXDataset2(id, cache = rpxCache())

PXDataset(id, cache = rpxCache())

\S4method{pxid}{PXDataset2}(object)

\S4method{pxurl}{PXDataset2}(object)

\S4method{pxtax}{PXDataset2}(object)

\S4method{pxref}{PXDataset2}(object)

pxtitle(object)

pxinstruments(object)

pxSubmissionDate(object)

pxPublicationDate(object)

pxptms(object)

pxprotocols(object, which = c("project", "samples", "data"))

\S4method{pxfiles}{PXDataset2}(object, n = 10, as.vector = TRUE)

\S4method{pxCacheInfo}{PXDataset2}(object)

\S4method{pxget}{PXDataset2}(object, list, cache = rpxCache())
}
\arguments{
\item{id}{\code{character(1)} containing a valid ProteomeXchange
identifier.}

\item{cache}{Object of class \code{BiocFileCache}. Default is to use
the central \code{rpx} cache returned by \code{rpxCache()}, but users
can use their own cache. See \code{\link[=rpxCache]{rpxCache()}} for details.}

\item{object}{An instance of class \code{PXDataset2}.}

\item{which}{\code{character()} with one or multiple protocols defined
as \code{"project"}, \code{"samples"} and \code{"data"}.}

\item{n}{\code{integer(1)} indicating the number of files to be printed.}

\item{as.vector}{\code{logical(1)} defining if the output should be a
vector of character with filenames (default) or a data.frame
with additional details about each file.}

\item{list}{\code{character()}, \code{numeric()} or \code{logical()} defining the
project files to be downloaded. This list of files can
retrieved with \code{pxfiles()}.}
}
\value{
The \code{PXDataset2()} returns a cached \code{PXDataset2}
object. It thus also modifies the cache used to projet
caching, as defined by the \code{cache} argument.
}
\description{
The \code{rpx} package provides the infrastructure to access, store and
retrieve information for ProteomeXchange (PX) data sets. This can
be achieved with \code{PXDataset2} objects can be created with the
\code{PXDataset2()} constructor that takes the unique ProteomeXchange
project identifier as input.

The new \code{PXDataset2} class superseeds the previous and now
deprecated \code{PXDataset} version.
}
\details{
The \code{rpx} packages uses caching to store ProteomeXchange projects
and project files. When creating an object with \code{PXDataset2()},
the cache is first queried for the projects identifier. If a
unique hit is found, the project is retrieved and returned. If no
matching project identifier is found, then the remote resource is
accessed to first create the new \code{PXDataset2()} project, then
cache it before returning it to the user. The same mechanism is
applied when project files are requested.

Caching is supported by BiocFileCache package. The \code{PXDataset2()}
constructor and the \code{px_get()} function can be passed a instance
of class \code{BiocFileCache} that defines the cache. The default is to
use the package-wide cache defined in \code{rpxCache()}. For more
details on how to manage the cache (for example if some files need
to be deleted), please refer to the \code{BiocFileCache} package
vignette and documentation. See also \code{\link[=rpxCache]{rpxCache()}} for additional
details.
}
\section{Slots}{

\describe{
\item{\code{px_id}}{\code{character(1)} containing the dataset's unique
ProteomeXchange identifier, as used to create the object.}

\item{\code{px_rid}}{\code{character(1)} storing the cached resource name in
the BiocFileCache instance stored in \code{cachepath}.}

\item{\code{px_title}}{\code{character(1)} with the project's title.}

\item{\code{px_url}}{`character(1) with the project's URL.}

\item{\code{px_doi}}{\code{character(1)} with the project's DOI.}

\item{\code{px_ref}}{\code{character} containing the project's reference(s).}

\item{\code{px_ref_doi}}{\code{character} containing the project's reference DOIs.}

\item{\code{px_pubmed}}{\code{character} containing the project's reference
PubMed identifier.}

\item{\code{px_files}}{\code{data.frame} containing information about the
project files, including file names, URIs and types. The files
are retrieved from the project's README.txt file.}

\item{\code{px_tax}}{\code{charcter} (typically of length 1) containing the
taxonomy of the sample.}

\item{\code{px_metadata}}{\code{list} containing the project's metadata, as
downloaded from the ProteomeXchange site. All slots but
\code{px_files} are populated from this one.}

\item{\code{cachepath}}{\code{character(1)} storing the path to the cache the
project object is stored in.}
}}

\section{Accessors}{

\itemize{
\item \code{pxfiles(object, n = 10, as.vector = TRUE)} by default,
invisibly returns all the project file names. The function
prints the first \code{n} files specifying whether they are local of
remote (based on the cache the object is stored in). The
printing can be ignored by wrapping the call in
\code{suppressMessages()}. If \code{as.vector} is set to \code{FALSE}, it
returns a \code{data.frame} with variables ID, NAME, URI, TYPE,
MAPPINGS and PXID. Note that the variables and their content
will depend on the \code{rpx} version that was installed when these
objects were created and cached.
\item \code{pxget(object, list, cache)}: \code{list} is a vector defining the
files to be downloaded. If \code{list = "all"}, all files are
downloaded. The file names, as returned by \code{pxfiles()} can also
be used. Alternatively, a \code{logical} or \code{numeric} index can be
used. If missing, the file to be downloaded can be selected
from a menu.

The argument \code{cache} can be passed to define the path to the
cache. The default cache is the packages' default as returned
by \code{rpxCache()}.
\item \code{pxtax(object)}: returns the taxonomic name of \code{object}.
\item \code{pxurl(object)}: returns the base url on the ProteomeXchange
server where the project files reside.
\item \verb{pxCacheInfo(object, cache): prints and invisibly returns }object\verb{'s caching information from }cache\verb{(default is}rpxCache()`). The return value is a named vector of length two
containing the resourne identifier and the cache location.
\item `pxtitle(object): returns the project's title.
\item \code{pxref(object)}: returns the project's bibliographic
reference(s).
\item \code{pxinstruments(object)}: returns the instrument(s) used to
acquire the data.
\item \code{pxptms(object)}: returns the PTMs searched for in the
experiment.
\item \code{pxprotocols(object, which)}: returns a list with the project
description, sample processing and/or data processing
protocols.
}
}

\examples{

px <- PXDataset("PXD000001")
px
pxtax(px)
pxurl(px)
pxref(px)
pxfiles(px)
pxfiles(px, as.vector = FALSE)

pxCacheInfo(px)

fas <- pxget(px, "erwinia_carotovora.fasta")
fas
library("Biostrings")
readAAStringSet(fas)
}
\references{
Vizcaino J.A. et al. 'ProteomeXchange: globally co-ordinated
proteomics data submission and dissemination', Nature Biotechnology 2014,
32, 223 -- 226, doi:10.1038/nbt.2839.

Source repository for the ProteomeXchange project:
https://code.google.com/p/proteomexchange/
}
\author{
Laurent Gatto
}
