% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCellMat.R
\name{GetCellMat}
\alias{GetCellMat}
\title{Extract real cell matrix from \code{CB2FindCell} output and optionally
filter out low-quality cells}
\usage{
GetCellMat(CBout, MTfilter = 0.25, MTgene = NULL)
}
\arguments{
\item{CBout}{Output object from \code{CB2FindCell}, or a sparse matrix 
(for example, from \code{QuickCB2}).}

\item{MTfilter}{Numeric value between 0 and 1. Default: \code{0.25}.
For each barcode, if the proportion of mitochondrial 
gene expression exceeds \code{MTfilter}, this barcode will be filtered out.
By default, cell barcodes with more than 25% mitochondrial UMI counts are 
filtered out. Set \code{MTfilter = 1} for no filtering.

The proportion of mitochondrial 
gene expressions is usually a criterion for evaluating cell quality, 
and is calculated using the scaled sum of all genes starting 
with "MT-" (human) or "mt-" (mouse) if row names are gene symbols, 
or customized mitochondrial genes specified by \code{MTgene}.}

\item{MTgene}{Character vector. User may specify customized mitochondrial
gene names to perform the filtering. This should correspond to a subset 
of row names in raw data.}
}
\value{
A \code{dgCMatrix} count matrix of real cells.
}
\description{
Handy function to extract real cell matrix from \code{CB2FindCell} output. 
It provides the option to filter out broken cells based on proportion 
of mitochondrial gene expressions. The input can also be a sparse matrix
only for cell filtering.
}
\examples{

# Please also refer to the example in function CB2FindCell.

# Simulate CB2FindCell output object.
library(SummarizedExperiment)
data(mbrainSub)
mbrainReal <- mbrainSub[,Matrix::colSums(mbrainSub)>500]

CBOut <- SummarizedExperiment(
    list(cell_matrix = mbrainReal[,sample(ncol(mbrainReal), 
                                          200, replace = TRUE)]))
                 
# Get cell matrix, filtering out barcodes with 
# more than 10\% of counts from mitochondrial genes.     

RealCell <- GetCellMat(CBOut, MTfilter = 0.1)
str(RealCell)             

}
