% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressPC.R
\name{decomposeR2}
\alias{decomposeR2}
\title{Decompose R-squared by Model Components}
\usage{
decomposeR2(pc, indep_var, df)
}
\arguments{
\item{pc}{A character string specifying the principal component column name in the data frame.}

\item{indep_var}{A character string specifying the independent variable specification.
Options are "cell_type", "cell_type * batch", or "cell_type * dataset".}

\item{df}{A data frame containing the principal component scores and categorical predictors.
Must include columns for the specified PC and predictor variables.}
}
\value{
A named list containing R-squared components:
  \item{cell_type}{Numeric value representing the R-squared explained by cell type main effect.}
  \item{batch/dataset}{Numeric value representing the R-squared explained by batch or dataset
    main effect (only for interaction models).}
  \item{interaction}{Numeric value representing the R-squared explained by the interaction term
    (only for interaction models).}
}
\description{
Decomposes the total R-squared from a linear model into individual components
representing the variance explained by main effects (cell type, batch/dataset)
and their interaction using sequential sum of squares.
}
\details{
This function performs R-squared decomposition using a sequential sum of squares approach,
which partitions the total explained variance into additive components. The decomposition
follows the hierarchical structure:
\enumerate{
  \item Cell type main effect
  \item Batch/dataset main effect (after accounting for cell type)
  \item Cell type × batch/dataset interaction (after accounting for main effects)
}

For simple cell type models, only the cell type component is returned. For interaction
models, all three components are computed. The method uses group means and residual
analysis to avoid computationally expensive matrix operations while maintaining
mathematical accuracy equivalent to ANOVA decomposition.
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
\keyword{internal}
