% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scgps_prediction_summary.R
\name{summary_prediction_lda}
\alias{summary_prediction_lda}
\title{get percent deviance explained for LDA model, from \code{n} bootstraps}
\usage{
summary_prediction_lda(LSOLDA_dat = NULL, nPredSubpop = NULL)
}
\arguments{
\item{LSOLDA_dat}{is a list containing the training results from 
\code{training}}

\item{nPredSubpop}{is the number of subpopulations in the target mixed 
population}
}
\value{
a dataframe containg information for the LDA prediction 
results, each column contains prediction results for all subpopulations from
each bootstrap run
}
\description{
the training results from \code{training} were written to
the object \code{LSOLDA_dat}, the \code{summary_prediction} summarises 
prediction explained for \code{n} bootstrap runs and also returns the best
deviance matrix for plotting, as well as the best matrix with Lasso genes
and coefficients
}
\examples{
c_selectID<-1
day2 <- day_2_cardio_cell_sample
mixedpop1 <-new_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
genes <-training_gene_sample
genes <-genes$Merged_unique
LSOLDA_dat <- bootstrap_prediction(nboots = 1,mixedpop1 = mixedpop1, 
mixedpop2 = mixedpop2, genes=genes, c_selectID, listData =list(),
    cluster_mixedpop1 = colData(mixedpop1)[,1],
    cluster_mixedpop2=colData(mixedpop2)[,1])
summary_prediction_lda(LSOLDA_dat=LSOLDA_dat, nPredSubpop=4)

}
