% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plots.R
\name{scmet_plot_efdr_efnr_grid}
\alias{scmet_plot_efdr_efnr_grid}
\title{Plot EFDR/EFNR grid}
\usage{
scmet_plot_efdr_efnr_grid(obj, task = "hvf")
}
\arguments{
\item{obj}{Either the scMET object after calling the
\code{\link{scmet_hvf_lvf}} functions or the object from calling the
\code{\link{scmet_differential}} function.}

\item{task}{String. When calling variable features, i.e. output of
\code{\link{scmet_hvf_lvf}}, it can be either "hvf" or "lvf". For
differential analysis, i.e. output of \code{\link{scmet_differential}}, it
can be either: (1) "diff_mu" for diff mean methylation, (2) "diff_epsilon"
for residual overdispersion, or (3) "diff_gamma" for overdispersion
analysis.}
}
\value{
A ggplot2 object.
}
\description{
Function for plotting the grid search performed to obtain the
optimal posterior evidence threshold to achieve a specific EFDR.
}
\examples{
# Fit scMET
obj <- scmet(Y = scmet_dt$Y, X = scmet_dt$X, L = 4, iter = 100)
obj <- scmet_hvf(scmet_obj = obj, delta_e = 0.7)
scmet_plot_vf_tail_prob(obj = obj, task = "hvf")

}
\seealso{
\code{\link{scmet}}, \code{\link{scmet_differential}},
\code{\link{scmet_hvf_lvf}}, \code{\link{scmet_plot_mean_var}},
\code{\link{scmet_plot_vf_tail_prob}}, \code{\link{scmet_plot_volcano}},
\code{\link{scmet_plot_ma}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
