% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scSEGIndex.R
\name{scSEGIndex}
\alias{scSEGIndex}
\title{Single Cell Stably Express Gene Index}
\usage{
scSEGIndex(
  exprs_mat,
  cell_type = NULL,
  BPPARAM = SerialParam(progressbar = TRUE),
  return_all = FALSE
)
}
\arguments{
\item{exprs_mat}{A log-transformed single-cell data, assumed to have no batch effect and covered a wide range of cell types. 
A n by m matrix, where n is the number of genes and m is the number of cells.}

\item{cell_type}{A vector indicating the cell type information for each cell in the gene expression matrix. 
If it is \code{NULL}, the function calculates the scSEG index without using F-statistics.}

\item{BPPARAM}{A \code{BiocParallelParam} class object from the \code{BiocParallel} package is used. Default is SerialParam(progressbar = TRUE).}

\item{return_all}{Default to FALSE. If set to TRUE, then all genes will be returned. Otherwise, 
only genes with less than 80 percent zeroes will be returned.}
}
\value{
Returns a data frame. 
Each row is a gene and each column is a statistic relating to the stability of expression of each gene.
The main statistic is the \code{segIdx} column, which is the SEG index.
}
\description{
This function computes the single-cell Stably Expressed Gene (scSEG) 
index from Lin. et al. (2019) for a given single-cell count data matrix. Each gene in the data is 
fitted with a gamma-normal mixture model and the final SEG index is computed as an average of 
key parameters that measure the expression stability of a gene. 

We recommend using either the pre-computed genes (see "See Also" below) or the top SEG genes 
from an user's own data as the control genes in the \code{scMerge} function 
(see the \code{ctl} argument in the \code{scMerge} function).
}
\examples{
## Loading example data
data('example_sce', package = 'scMerge')
## subsetting genes to illustrate usage.
exprs_mat = SummarizedExperiment::assay(example_sce, 'logcounts')[1:110, 1:20]
set.seed(1)
result1 = scSEGIndex(exprs_mat = exprs_mat)
## If parallelisation is needed:
param = BiocParallel::MulticoreParam(workers = 2, progressbar = TRUE)
result2 = scSEGIndex(exprs_mat = exprs_mat, BPPARAM = param)
## Closing the parallelisation
BiocParallel::register(BPPARAM = BiocParallel::SerialParam())
}
\references{
Evaluating stably expressed genes in single cells (2019). doi:10.1093/gigascience/giz106.
}
\seealso{
Download human SEG directly from this \href{http://www.maths.usyd.edu.au/u/pengyi/software/scHK/scHK_human.xlsx}{link}; 
Download mouse SEG directly from this \href{http://www.maths.usyd.edu.au/u/pengyi/software/scHK/scHK_mouse.xlsx}{link}.
}
\author{
Shila Ghazanfar, Yingxin Lin, Pengyi Yang
}
